package nemosofts.voxradio.utils.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;

import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.utils.SharedPref;

public class TimeReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(final Context context, Intent intent) {
        if (intent != null){
            SharedPref sharedPref = new SharedPref(context);
            try {
                if (Boolean.TRUE.equals(sharedPref.getIsSleepTimeOn())) {
                    sharedPref.setSleepTime(false, 0, 0);
                    if (PlayerService.getInstance() != null) {
                        intent = new Intent(context, PlayerService.class);
                        intent.setAction(PlayerService.ACTION_STOP);
                        context.startService(intent);
                    }
                    Toast.makeText(context, "Time End Stop Audio", Toast.LENGTH_SHORT).show();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}